<?php
    if (!isset($asset) && isset($attachment)) {
        $asset = $attachment->path ?? '';
    }

    if (!empty($asset)) {
        $parts = explode('.', $asset);
        $extension = AttachmentHelper::getAttachmentType(end($parts));
        $asset = Storage::url($asset);
    } else {
        $extension = 'unknown';
    }
?>

<!--[if BLOCK]><![endif]--><?php if(!empty($asset)): ?>
    <a href="<?php echo e($asset); ?>" target="_blank">
        <!--[if BLOCK]><![endif]--><?php switch($extension):
            case ('document'): ?>
                <img src="<?php echo e(asset('/img/pdf-preview.svg')); ?>" class="admin-id-asset"/>
                <?php break; ?>
            <?php case ('image'): ?>
                <img src="<?php echo e($asset); ?>" class="admin-id-asset"/>
                <?php break; ?>
            <?php case ('video'): ?>
                <video class="video-preview w-75" src="<?php echo e($asset); ?>#t=0.001" controls controlsList="nodownload" preload="metadata"></video>
                <?php break; ?>
            <?php case ('audio'): ?>
                <audio class="video-preview w-75" src="<?php echo e($asset); ?>#t=0.001" controls controlsList="nodownload" preload="metadata"></audio>
                <?php break; ?>
        <?php endswitch; ?><!--[if ENDBLOCK]><![endif]-->
    </a>
<?php else: ?>
    <span class="text-sm text-gray-500">No preview available</span>
<?php endif; ?><!--[if ENDBLOCK]><![endif]-->
<?php /**PATH /home/ygnbmjdo/funmate/resources/views/filament/partials/file-preview-box.blade.php ENDPATH**/ ?>