<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;

class PollUserAnswer extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'poll_id',
        'user_id',
        'answer_id',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [

    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [

    ];

    /*
     * Relationships
     */

    public function user()
    {
        return $this->hasOne('App\Model\User', 'id', 'user_id')->with(['posts']);
    }

    /**
     * Get the poll associated with this user's answer.
     */
    public function poll()
    {
        return $this->belongsTo(Poll::class, 'poll_id');
    }

    /**
     * Get the specific poll answer this user chose.
     */
    public function answer()
    {
        return $this->belongsTo(PollAnswer::class, 'answer_id');
    }
}
